﻿using System.ComponentModel.DataAnnotations;
using System.Device.Location;
using BingMapsRESTToolkit;
using PpmsDataWebService.ModelsEnumTypes;

namespace PpmsDataWebService.Models
{
    public class ProviderLocatorResult
    {
        [Key]
        public double Miles { get; set; }

        [Key]
        public double Minutes { get; set; }

        public string ProviderName { get; set; }

        public string ProviderSpecialty { get; set; }

        public string SpecialtyCode { get; set; }

        public bool? PreferredMeansReceivingReferralHSRM { get; set; }

        public bool? PreferredMeansReceivingReferralSecuredEmail { get; set; }

        public bool? PreferredMeansReceivingReferralMail { get; set; }

        public bool? PreferredMeansReceivingReferralDirectMessaging { get; set; }

        public bool? PreferredMeansReceivingReferralFax { get; set; }

        public HPP? HPP { get; set; }

        public string CareSite { get; set; }

        public string CareSiteAddress { get; set; }

        public string CareSiteAddressStreet { get; set; }

        public string CareSiteAddressCity { get; set; }

        public string CareSiteAddressState { get; set; }

        public string CareSiteAddressZipCode { get; set; }

        public string CareSitePhoneNumber { get; set; }

        public string WorkHours { get; set; }

        public ProviderGender? ProviderGender { get; set; }

        public string ProviderNetwork { get; set; }

        public int? NetworkId {get; set;}

        public bool? ProviderAcceptingNewPatients { get; set; }

        public bool? ProviderPrimaryCare { get; set; }

        public int? QualityRanking { get; set; }

        public string ProviderIdentifier { get; set; }

        public double? Latitude { get; set; }

        public double? Longitude { get; set; }

       // public int ContextSeconds { get; set; }

      //  public int GeocodeAddressSeconds { get; set; }

      //  public int RetrieveCRMResultsSeconds { get; set; }

      //  public int DriveTimeCalcSeconds { get; set; }

      //  public int MappingSeconds { get; set; }

    }
}